/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet.xport;

import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.xport.TaskletControlException;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TaskletController {
    private static final String TRACE_MASKT = "XTSKTCLT";
    private static final String TRACE_MASKF = "XTSKTCLF";
    private static final String TRACE_MASKD = "XTSKTCLD";
    private static HashMap cache = new HashMap();
    private static final String[] unauthenticatedTasklets = new String[]{"com.ibm.hwmca.base.logon.LogonTasklet", "com.ibm.hwmca.fw.log.LoggerTasklet"};
    private static final String[] anyUserTasklets = new String[]{"com.ibm.hwmca.fw.task.LauncherTasklet", "com.ibm.hwmca.fw.ui.UITasklet", "com.ibm.hwmca.fw.ui.UIEventTasklet", "com.ibm.hwmca.fw.ui.UIQueryTasklet", "com.ibm.hwmca.fw.managed.ClassIdTasklet"};
    private static final String[] unauthenticatedLocalOnlyTasklets = new String[]{"com.ibm.hwmca.fw.system.StartupTasklet", "com.ibm.hwmca.fw.system.KeepAliveTasklet"};
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Task;

    public static boolean requiresAuthentication(String tasklet) {
        boolean needsAuth = true;
        for (int i = 0; i < unauthenticatedTasklets.length && needsAuth; ++i) {
            needsAuth = !unauthenticatedTasklets[i].equals(tasklet);
        }
        if (CommonSystem.getCommonSystem().isUsingHTML()) {
            return false;
        }
        UserContext uc = UserContext.getCurrentUserContext();
        if (needsAuth && uc != null && uc.isLocalContext()) {
            for (int i = 0; i < unauthenticatedLocalOnlyTasklets.length && needsAuth; ++i) {
                needsAuth = !unauthenticatedLocalOnlyTasklets[i].equals(tasklet);
            }
        }
        return needsAuth;
    }

    public static synchronized void checkPermission(String tasklet) {
        Trace.trace(TRACE_MASKF, "-> TaskletController.checkPermission (" + tasklet + ")");
        TaskletControlException ctrlException = null;
        try {
            String standalone = System.getProperty("STANDALONE_TASK", "NO");
            if ("YES".equals(standalone)) {
                Trace.trace(TRACE_MASKF, "skipping permission check for standalone tasklet");
            } else if (TaskletController.requiresAuthentication(tasklet)) {
                UserContext uc = UserContext.getCurrentUserContext();
                boolean anyUser = false;
                if (uc.isAuthenticated()) {
                    for (int i = 0; i < anyUserTasklets.length && !anyUser; ++i) {
                        anyUser = anyUserTasklets[i].equals(tasklet);
                    }
                }
                if (!anyUser) {
                    String userid = uc.getUserid();
                    if (userid != null) {
                        List permissions = null;
                        if (cache.containsKey(userid)) {
                            WeakReference ref = (WeakReference)cache.get(userid);
                            permissions = (List)ref.get();
                            if (permissions == null) {
                                cache.remove(userid);
                            } else {
                                Trace.trace(TRACE_MASKF, "TaskletController: already existing permissions found in cache for userid " + userid + ".");
                            }
                        }
                        if (permissions == null) {
                            permissions = new ArrayList();
                            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
                            Set tasks = mom.getInventory(new ClassId(class$com$ibm$hwmca$fw$managed$Task == null ? (class$com$ibm$hwmca$fw$managed$Task = TaskletController.class$("com.ibm.hwmca.fw.managed.Task")) : class$com$ibm$hwmca$fw$managed$Task));
                            Iterator i = tasks.iterator();
                            while (i.hasNext()) {
                                Task task;
                                List tasklets;
                                Object elem = i.next();
                                if (elem == null || !(elem instanceof Task) || (tasklets = (task = (Task)elem).getAssociatedTasklets()) == null) continue;
                                Iterator k = tasklets.iterator();
                                while (k.hasNext()) {
                                    permissions.add(k.next());
                                }
                            }
                            cache.put(userid, new WeakReference(permissions));
                            Trace.trace(TRACE_MASKF, "TaskletController: newly built permissions added to cache for userid " + userid + ".");
                            Trace.trace(TRACE_MASKF, "TaskletController: " + permissions.size() + " permissions found for userid " + userid + ".");
                        }
                        boolean permitted = false;
                        Iterator i = permissions.iterator();
                        while (!permitted && i.hasNext()) {
                            if (!tasklet.equals(i.next())) continue;
                            permitted = true;
                        }
                        if (!permitted) {
                            Trace.trace(TRACE_MASKF, "TaskletController.checkPermission: User not permitted for tasklet " + tasklet + ".");
                            ctrlException = new TaskletControlException("User not permitted for tasklet " + tasklet + ".");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "TaskletController.checkPermission: null userid");
                        ctrlException = new TaskletControlException("Null userid for UserContext");
                    }
                }
            }
        }
        catch (Throwable thrown) {
            Trace.trace(TRACE_MASKF, "TaskletController.checkPermission caught: " + thrown);
            Trace.trace(TRACE_MASKF, thrown);
            throw new TaskletControlException(thrown);
        }
        if (ctrlException != null) {
            Trace.trace(TRACE_MASKD, "-> TaskletController.checkPermission (not allowed)");
            throw ctrlException;
        }
        Trace.trace(TRACE_MASKF, "<- TaskletController.checkPermission (allowed)");
    }

    public static synchronized void flushCache() {
        cache.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

